/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.actorbar;

import com.quantumdata.sct.dao.impl.StandardDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.StandardVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityarea.ActivityArea;
import com.quantumdata.sct.gui.activityarea.ToolsActivityArea;
import com.quantumdata.sct.gui.actorbar.SecondaryActorBar;
import com.quantumdata.sct.gui.actorbar.SecondaryActorBarButton;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class StandardsDisplayPanel
extends SecondaryActorBar {
    ActivityArea activityArea;
    ActivityArea edidActivityArea;
    ActivityArea hdcpActivityArea;
    JPopupMenu menu;

    public StandardsDisplayPanel(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI);
    }

    public String getName() {
        return "Standard";
    }

    public void addButtons() {
        this.activityArea = new ToolsActivityArea(this.toolUI);
        ((ToolsActivityArea)this.activityArea).addCDFOnly(this.toolUI);
        ((ToolsActivityArea)this.activityArea).initialize(this.toolUI);
        try {
            StandardDAO standardDAO = (StandardDAO)XMLDAOFactory.getStandardDAO();
            IPersistable[] iPersistableArray = standardDAO.findByAll();
            this.buttons = new SCTButton[iPersistableArray.length];
            for (int i = 0; i < iPersistableArray.length; ++i) {
                StandardVO standardVO = (StandardVO)iPersistableArray[i];
                if (i == 0) {
                    SCTSelection.instance().setStandardID(standardVO.getId().toString());
                }
                this.buttons[i] = new SecondaryActorBarButton(standardVO.get_notation(), this.activityArea);
                this.buttons[i].putClientProperty("StandardVO", standardVO);
                this.buttons[i].addActionListener(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void createButtonList(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem;
        try {
            StandardDAO standardDAO = (StandardDAO)XMLDAOFactory.getStandardDAO();
            IPersistable[] iPersistableArray = standardDAO.findByAll();
            this.buttons = new SCTButton[iPersistableArray.length];
            for (int i = 0; i < iPersistableArray.length; ++i) {
                StandardVO standardVO = (StandardVO)iPersistableArray[i];
                if (i == 0) {
                    SCTSelection.instance().setStandardID(standardVO.getId().toString());
                }
                jMenuItem = new JMenuItem(standardVO.get_notation());
                jMenuItem.setBackground(SCTConstants.DIALOG_BG_COLOR);
                jMenuItem.putClientProperty("StandardVO", standardVO);
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand("Standards" + i);
                jPopupMenu.add(jMenuItem);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jMenuItem = new JMenuItem("EDID");
        jMenuItem.setBackground(SCTConstants.DIALOG_BG_COLOR);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("EDID");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("HDCP");
        jMenuItem.setBackground(SCTConstants.DIALOG_BG_COLOR);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("HDCP");
        jPopupMenu.add(jMenuItem);
        this.menu = jPopupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getActionCommand().equals("EDID")) {
            this.toolUI.setActivityArea(this.edidActivityArea);
            ((ToolsActivityArea)this.edidActivityArea).setEdidProductName("Manufacturer_Product");
        } else if (actionEvent.getActionCommand().equals("HDCP")) {
            this.toolUI.setActivityArea(this.hdcpActivityArea);
            ((ToolsActivityArea)this.hdcpActivityArea).setHdcpProductName("Manufacturer_Product");
        } else if (actionEvent.getActionCommand().substring(0, 9).equals("Standards")) {
            StandardVO standardVO = (StandardVO)((JMenuItem)this.menu.getComponent(actionEvent.getActionCommand().charAt(9) - 48)).getClientProperty("StandardVO");
            if (standardVO != null) {
                SCTSelection.instance().setStandardID(standardVO.getId().toString());
            }
            this.toolUI.setActivityArea(this.activityArea);
        } else {
            SecondaryActorBarButton secondaryActorBarButton = (SecondaryActorBarButton)actionEvent.getSource();
            StandardVO standardVO = (StandardVO)secondaryActorBarButton.getClientProperty("StandardVO");
            if (standardVO != null) {
                SCTSelection.instance().setStandardID(standardVO.getId().toString());
            }
        }
    }
}

